create or replace package tbicds.PCK_PWEVENT
AUTHID CURRENT_USER 
is
  /* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
  --type defs to return recordsets
  type RetRefCursor is ref cursor;
  type refCursor is ref cursor;
 
  --constants
  c_nSUBJECTIVE  constant number := 1;
  c_nOBJECTIVE   constant number := 2;
  c_nASSESSMENT  constant number := 3;
  c_nPLAN        constant number := 4;
  c_nREVIEW      constant number := 5;
  c_nOTHER       constant number := 6;
   
  c_nBETTER      constant number := 1;
  c_nSAME        constant number := 2;
  c_nWORSE       constant number := 3;

/*gets recent clinics used for events*/
procedure GetRecentClinicRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      );
      
/*gets recent note titles used for events*/
procedure GetRecentNoteTitleRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      );
      
/***
insert modules into the pat pw event module 
****/
procedure InsertPatPWEventModule (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      pi_vPatientID             in varchar2,
      pi_nPatPWEventID          in number,
      pi_nMID                   in number,
      
      po_nEventModuleID         out number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      );
      
procedure InsertPatPWEvent (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      
      pi_vPatientID             in varchar2,
      pi_nPatPWID               in number,
   
      pi_vEventTitle            in varchar2,
      pi_dtEventDate            in date,
      
      po_nPatPWEventID          out number,
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      );
      
/*****
Gets todays pathway events associated with a patient
******/
procedure GetTodaysPatPWEventRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nPatPWID               in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      );
      
/*gets the no pathway for a patient*/
procedure GetNoPathwayRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      );
      
/*gets all open encounters for a patient*/
procedure GetOpenEncountersRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      );
       
/*updates the intrument date*/
procedure UpdateInstrumentDate (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      pi_vPatientID             in varchar2,
      pi_nIntakeID              in number,
      pi_dtDate                 in date,
                      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      );
      
/*get the most recent medical history record*/
procedure GetMedicalHxRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      );
      
/*insert a new medical history record*/
procedure InsertMedicalHx ( pi_vSessionID           in varchar2,
                            pi_vSessionClientIP     in varchar2,
                            pi_nUserID              in number,
                                
                            pi_nRegionID            in number,
                            pi_nSiteID              in number,
                            pi_vPatientID           in varchar2,
                            pi_nPatPWID             in number,
                            pi_nPatPWEventID        in number,
                            
                            po_nStatusCode           out number,
                            po_vStatusComment        out varchar2
                          );
                          
/*get the most recent medical history intake_id*/ 
procedure GetMedicalHxIntakeID(pi_vSessionID       in varchar2,
                               pi_vSessionClientIP in varchar2,
                               pi_nUserID          in number,   
                               pi_vPatientID       in varchar2,
                               po_nIntakeID        out number,   
                               po_nStatusCode      out number,
                               po_vStatusComment   out varchar2);
                          
/*save note progress, used while the note is being written but before 
it is commited*/
procedure SaveNoteProgress (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      pi_vPatientID             in varchar2,
      pi_nPatPWEventID          in number,
      
      pi_nEncounterType         in number,
      pi_vNoteTitle             in varchar2,
      pi_vLocation              in varchar2,
      pi_vCosigner              in varchar2,
      pi_vConsult               in varchar2,
      pi_vNote                  in clob,
                      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      );


/*write note details to tbi cds after commited to MDWS*/
procedure WriteNote (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      pi_vPatientID             in varchar2,
      pi_nPatPWEventID          in number,
      
      pi_vDFN                   in varchar2,
      pi_vDUZ                   in varchar2,
      pi_vEncounterID           in varchar2,
      pi_vConsultIEN            in varchar2,
      pi_vCosignerDUZ           in varchar2,
      pi_vNoteTitleIEN          in varchar2,
      pi_vTIUNoteID             in varchar2,
      pi_vTIUNote               in clob,
      pi_nClinicID              in number,
      pi_nEncounterType         in number,
      pi_vNoteTitle             in varchar2,
      pi_vLocation              in varchar2,
      pi_vCosigner              in varchar2,
      pi_vConsult               in varchar2,
      pi_vTBINote               in clob,
                      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      );
      
 /******
 get list of event entry types Subjective, Objective, Assessment, Plan etc...
 ******/ 
 procedure GetEventEntryTypeRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      );
      
 /***
 Gets the previous score value for a mid
 ***/ 
 function GetPrevIntakeScore(pi_nMID in number,
                            pi_vPatientID in varchar2,
                            pi_nIntakeID in number)
  
 return number;
 
 /***
 Gets the previous score value for the subscale of a mid
 ***/
 function GetPrevIntakeSubscaleScore(pi_nMID in number,
                                     pi_vPatientID in varchar2,
                                     pi_nIntakeID in number,
                                     pi_nSeries in number)
 return number;             
 
 /***
 Gets the next event id after the event past in
 ***/
 function GetNextPatPWEventID(pi_nPatPWEventID in number,
                             pi_vPatientID in varchar2)
  
 return number;
 

 
 /*inserts a new pathway event*/
procedure InsertPWEvent ( pi_vSessionID           in varchar2,
                          pi_vSessionClientIP     in varchar2,
                          pi_nUserID              in number,
                                
                          pi_nRegionID            in number,
                          pi_nSiteID              in number,
                          pi_vPatientID           in varchar2,
                          pi_nPatPWID             in number,
                          pi_vEventTitle          in varchar2,
                          pi_dtEventDate          in varchar2,
                          pi_nRelatedEventID      in number,
                                
                          po_nPatPWEventID           out number,
                          po_nStatusCode           out number,
                          po_vStatusComment        out varchar2
                          );
                           
  /******
  insert an event entry 
  ******/  
  procedure InsertPWEventEntry (  pi_vSessionID             in varchar2,
                                  pi_vSessionClientIP       in varchar2,
                                  pi_nUserID                in number,
                                
                                  pi_vPatientID             in varchar2,
                                  pi_nPatPWEventID          in number,
                                  pi_nPWEventModuleID       in number,
                                  pi_nEventEntryTypeID      in number,
                                  pi_dtEventDate            in date,
                                  pi_vEventEntryComment     in varchar2,
                                  pi_nEventStatusID         in number,
                                  pi_nEventSeverityID       in number,
                                
                                  po_nEventEntryID          out number,
                                
                                  po_nStatusCode           out number,
                                  po_vStatusComment        out varchar2
                               );
                               
  /******
  update an event entry 
  ******/  
  procedure UpdatePWEventEntry (  pi_vSessionID             in varchar2,
                                  pi_vSessionClientIP       in varchar2,
                                  pi_nUserID                in number,
                                
                                  pi_nEventEntryID          in number,
                                  pi_nPWEventModuleID       in number,
                                  pi_dtEventDate            in date,
                                  pi_vEventEntryComment     in varchar2,
                                  pi_nEventStatusID         in number,
                                  pi_nEventSeverityID       in number,
                             
                                  po_nStatusCode           out number,
                                  po_vStatusComment        out varchar2
                               );
  
  /*
update the plan portion of the event
*/
procedure UpdatePWEventPlan (  pi_vSessionID             in varchar2,
                               pi_vSessionClientIP       in varchar2,
                               pi_nUserID                in number,
                               
                               pi_nPatPWEventID          in number,
                               pi_nPatPWPlanEventID      in number,
                               pi_vPlanText              in clob,
                               
                               po_nStatusCode           out number,
                               po_vStatusComment        out varchar2
                             );
                             
  /***
  delete entry
  ***/
  procedure DeletePWEventEntry (  pi_vSessionID             in varchar2,
                                  pi_vSessionClientIP       in varchar2,
                                  pi_nUserID                in number,
                                 
                                  pi_nEventEntryID          in number,
                                  po_nStatusCode           out number,
                                  po_vStatusComment        out varchar2
                               );
                                                        
  /******
  get list of event statuses Better, Same, Worse etc...
  ******/  
  procedure GetEventStatusRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      );
      
  /******
  get list of event severities
  ******/  
  procedure GetEventSeverityRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      );
      
  /******
  get list of event entries for an event
  ******/ 
  procedure GetEventEntryRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nPatPWEventID          in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      );
      
  /***
  Get all outcome measures associated with this event
  ***/
  procedure GetOutcomeMeasuresRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nPatPWEventID          in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      );
      
   /***
   Get all scores for an intake
   ***/
   procedure GetIntakeScoreRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nIntakeID              in number,
      pi_nMID                   in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      );
      
    /*****
    Gets next pathway event associated with a patient
    ******/
    procedure GetNextPatPWEventRS (
          pi_vSessionID             in varchar2,
          pi_vSessionClientIP       in varchar2,
          pi_nUserID                in number,
          pi_vPatientID             in varchar2,
          pi_nPatPWEventID          in number,
          po_nStatusCode            out number,
          po_vStatusComment         out varchar2,
          rs                        out RetRefCursor
          );

end PCK_PWEVENT;
/

